function [RRC0] = rrcFromAxles(axles)

    % Check the relative loads
    axleLoad = axles.relLoad;
    if sum(axleLoad) ~= 1
        warning("The relative axle loads do not add up to one.")
    end
    
    RRC = axles.RRC_ISO;
    Fz = axles.Fz_ISO;
    
    RRC0 = @(mass) sum( axleLoad .* RRC .* ( ( axleLoad .* mass .* 9.81 ) ./ ( 2 .* Fz ) ) .^ (-0.1) );

end